commands_to_follow =  {}
commands_counter = 0

function printTable(table)
    for i = 1, #table do
        for j = 1, #table[i] do
            if type(table[i][j]) == "table" then
                for k, v in ipairs(table[i][j]) do
                    --io.write("Inner[" .. k .. "]: " .. tostring(v) .. "\t")
                end
            else
                io.write(table[i][j] .. "\t")
            end
        end
        io.write("\n")
    end
end

function printArray(arr)
    for i = 1, #arr do
        print(arr[i])
    end
end

function buildResultsTransmissionTable(results, results_structure)
    transmission_table = {}
    for i = 1, 3 do
        transmission_table[i] = {}
    end

    transmission_table[1][1] = "Current Coordinates: "
    transmission_table[1][2] = ("0,0,0")
    while transmission_table[1][2] == ("0,0,0") do
        transmission_table[1][2] = tostring(vector.new(gps.locate()))
    end

    if results_structure == "default" then
        transmission_table[2][1] = "Success: "
        transmission_table[2][2] = tostring(results[1])
        transmission_table[3][1] = "Failure Reason: "
        transmission_table[3][2] = tostring(results[2])
        
    elseif results_structure == "single_response" then
        transmission_table[2][1] = "Success: "
        transmission_table[2][2] = tostring(results[1])

    elseif results_structure == "inspect" then
        transmission_table[2][1] = "Success: "
        transmission_table[2][2] = tostring(results[1])
        transmission_table[3][1] = "Block Type: "

        if (tostring(results[2].name) ~= "nil") then
            transmission_table[3][2] = results[2].name
        else
            transmission_table[3][2] = "minecraft:air"
        end

    elseif results_structure == "mining_mode" then
        transmission_table[2][1]= "Success: "
        transmission_table[2][2]= tostring(results[1])
        transmission_table[3][1]= "Mining Mode: "
        transmission_table[3][2]= tostring(results[2])
    end

    return transmission_table
end

function resolveCommand(command)
    results = {}
    results_structure = "default"

    if command == "xyz_ping" then
        results = {1}
        results_structure = "single_response"

    elseif command == "turtle.forward()" then
        results = {turtle.forward()}

    elseif command == "turtle.back()" then
        results = {turtle.back()}

    elseif command == "turtle.turnLeft()" then
        results = {turtle.turnLeft()}

    elseif command == "turtle.turnRight()" then
        results = {turtle.turnRight()}

    elseif command == "turtle.up()" then
        results = {turtle.up()}

    elseif command == "turtle.detect()" then
        results = {turtle.detect()}
        results_structure = "single_response"

    elseif command == "turtle.inspect()" then
        results = {turtle.inspect()}
        results_structure = "inspect"

    elseif command == "turtle.inspectUp()" then
        results = {turtle.inspectUp()}
        results_structure = "inspect"

    elseif command == "turtle.inspectDown()" then
        results = {turtle.inspectDown()}
        results_structure = "inspect"

    elseif command == "turtle.getFuelLevel()" then
        results = {turtle.getFuelLevel()}
        results_structure = "single_response"

    elseif command == "turtle.refuel()" then
        results = {turtle.refuel()}
        results_structure = "single_response"

    elseif command == "turtle.suck()" then
        results = {turtle.suck()}

    elseif command == "turtle.getFuelLevel()" then
        results = {turtle.getFuelLevel()}
        results_structure = "single_response"

    elseif command == "depositItems()" then
        results[1] = false
        --results[1] = depositItems()
        results_structure = "single_response"

    elseif command == "dropJunk()" then
        results[1] = false
        --results[1] = dropJunk()
        results_structure = "single_response"
    
    elseif command == "raw_command" then
        results = {pcall(loadstring(command))}
        results_structure = "single_response"

    elseif command == "toggleMiningMode()" then
        results[1] = false
        --results[1] = toggleMiningMode()
        results[2] = false
        --results[2] = mining_mode
        results_structure = "mining_mode"

    elseif command == "disableMiningMode()" then
        results[1] = false
        --results[1] = disableMiningMode()
        results[2] = false
        --results[2] = mining_mode
        results_structure = "mining_mode"

    else
        results[1] = false
        results[2] = "Unable to resolve command"

    end
    return buildResultsTransmissionTable(results, results_structure)
end

function getCommand()
    rednet.open("right")
    print("listening for a new command")
    sender_id, command, protocol = rednet.receive("to_turtle" .. tostring(os.getComputerID()))
    io.write("Command: ")
    print(command)
    command_results = resolveCommand(command)   
    print("[------ Results Table ------]")
    printTable(command_results)
    rednet.broadcast(command_results,"from_turtle" .. tostring(os.getComputerID()))
    return command
end

function getTurtles()
    turtles = {}
    turtles[1] = 0
    turtles[2] = 12
    turtles[3] = 13
    turtles[4] = 14
    turtles[5] = 15
    turtles[6] = 16
    turtles[7] = 17
    turtles[8] = 18
    turtles[9] = 29
    turtles[10] = 20
    return turtles
end

function getChunkyTurtles()
    chunky_turtles = {}
    chunky_turtles[1] = 32
    chunky_turtles[2] = 22
    chunky_turtles[3] = 23
    chunky_turtles[4] = 24
    chunky_turtles[5] = 25
    chunky_turtles[6] = 26
    chunky_turtles[7] = 21
    chunky_turtles[8] = 28
    chunky_turtles[9] = 31
    chunky_turtles[10] = 30
    return chunky_turtles
end

function getTurtleToFollow()
    turtles = getTurtles()
    chunky_turtles = getChunkyTurtles()
    current_chunky_turtle = os.getComputerID()
    for i = 1 , 10 do
        if(current_chunky_turtle == chunky_turtles[i]) then
            turtle_to_follow = turtles[i]
        end
    end
    return turtle_to_follow
end


function chunkyEavesDropper()
    rednet.open("right")
    turtle_to_follow = getTurtleToFollow()
    current_command = ""

    print("listening for a new command")
    sender_id, command, protocol = rednet.receive("to_turtle" .. tostring(turtle_to_follow))
    table.insert(commands_to_follow, command)
    commands_counter = commands_counter + 1

    current_command = commands_to_follow[commands_counter-13]
    print("Current Command: ")
    print(commands_counter-13)
    print(current_command)
    
    command_results = resolveCommand(tostring(current_command))
    print("[------ Results Table ------]")
    printTable(command_results)
    rednet.broadcast(command_results,"from_turtle" .. tostring(os.getComputerID()))

    next_command = commands_to_follow[commands_counter-12]
    print("Next Command: ")
    print(commands_counter-12)
    print(next_command)
    
    return current_command
end

function chunkyStartBuffer()
    table.insert(commands_to_follow, "xyz_ping")
    commands_counter = commands_counter + 1
    table.insert(commands_to_follow, "xyz_ping")
    commands_counter = commands_counter + 1
    table.insert(commands_to_follow, "xyz_ping")
    commands_counter = commands_counter + 1
    table.insert(commands_to_follow, "xyz_ping")
    commands_counter = commands_counter + 1
    table.insert(commands_to_follow, "xyz_ping")
    commands_counter = commands_counter + 1
    table.insert(commands_to_follow, "xyz_ping")
    commands_counter = commands_counter + 1
    table.insert(commands_to_follow, "xyz_ping")
    commands_counter = commands_counter + 1
    table.insert(commands_to_follow, "xyz_ping")
    commands_counter = commands_counter + 1
    table.insert(commands_to_follow, "xyz_ping")
    commands_counter = commands_counter + 1
    table.insert(commands_to_follow, "xyz_ping")
    commands_counter = commands_counter + 1
    table.insert(commands_to_follow, "xyz_ping")
    commands_counter = commands_counter + 1
    table.insert(commands_to_follow, "turtle.forward()")
    commands_counter = commands_counter + 1
    table.insert(commands_to_follow, "turtle.forward()")
    commands_counter = commands_counter + 1
    table.insert(commands_to_follow, "turtle.forward()")
    commands_counter = commands_counter + 1
end


function main()
    os.setComputerLabel("ID: " .. os.getComputerID())
    command_log = {}
    chunkyStartBuffer()
    while true do
        table.insert(command_log,chunkyEavesDropper())
    end
end

main()