local args = { ... }
rednet.open("right")
sendCommand_delay = 0
current_direction = ""

function getTurtles()
    turtles = {}
    turtles[1] = 0
    turtles[2] = 12
    turtles[3] = 13
    turtles[4] = 14
    turtles[5] = 15
    turtles[6] = 16
    turtles[7] = 17
    turtles[8] = 18
    turtles[9] = 29
    turtles[10] = 20
    return turtles
end

function getChunkyTurtles()
    chunky_turtles = {}
    chunky_turtles[1] = 32
    chunky_turtles[2] = 22
    chunky_turtles[3] = 23
    chunky_turtles[4] = 24
    chunky_turtles[5] = 25
    chunky_turtles[6] = 26
    chunky_turtles[7] = 21
    chunky_turtles[8] = 28
    chunky_turtles[9] = 31
    chunky_turtles[10] = 30
    return chunky_turtles
end

function getTurtleNumber(target_turtle)
    turtles = {}
    turtles = getTurtles()
    for i = 1, #turtles do
        if (target_turtle == turtles[i]) then
            turtle_number = i
        end
    end
    return turtle_number
end

function getMinerForChunky(target_turtle)
    turtles = getTurtles()
    chunky_turtles = getChunkyTurtles()
    for i = 1 , 10 do
        if(target_turtle == chunky_turtles[i]) then
            miner_turtle = turtles[i]
        end
    end
    return miner_turtle
end


function printTable(table)
    local i = 1
    for i = 1, #table do
        for j = 1, #table[i] do
            if type(table[i][j]) == "table" then
                for k, v in ipairs(table[i][j]) do
                    --io.write("Inner[" .. k .. "]: " .. tostring(v) .. "\t")
                end
            else
                io.write(table[i][j] .. "\t")
            end
        end
        io.write("\n")
    end
end

function printArray(arr)
    for i = 1, #arr do
        print(arr[i])
    end
end

function printArrayReverse(arr)
    for i = #arr, 1, -1 do
        print(arr[i])
    end
end

function reverseMoves(target_turtle, moves_list)
    for i = #moves_list, 1, -1 do
        if (moves_list[i] == "forward") then
            sendCommand(target_turtle,"turtle.back()")
        elseif (moves_list[i] == "left") then
            sendCommand(target_turtle,"turtle.turnRight()")
        elseif (moves_list[i] == "right") then
            sendCommand(target_turtle,"turtle.turnLeft()")
        elseif (moves_list[i] == "back") then
            sendCommand(target_turtle,"turtle.forward()")
        elseif (moves_list[i] == "up") then
            sendCommand(target_turtle,"turtle.down()")
        elseif (moves_list[i] == "down") then
            sendCommand(target_turtle,"turtle.up()")
        end
    end
end

function escapeHole(target_turtle)
    airblock_count = 0
    escape_trajectory = ""

    while airblock_count <= 2 do
        up_block, down_block, forward_block, left_block, behind_block, right_block = getSurroundingBlocks(target_turtle)
        airblock_count = 0
        if ((up_block == "minecraft:air") or (up_block == "minecraft:water") or (up_block == "minecraft:lava")) then
            airblock_count = airblock_count + 1
        end
        if ((down_block == "minecraft:air") or (down_block == "minecraft:water") or (down_block == "minecraft:lava")) then
            airblock_count = airblock_count + 1
        end
        if ((forward_block == "minecraft:air") or (forward_block == "minecraft:water") or (forward_block == "minecraft:lava")) then
            airblock_count = airblock_count + 1
        end
        if ((left_block == "minecraft:air") or (left_block == "minecraft:water") or (left_block == "minecraft:lava")) then
            airblock_count = airblock_count + 1
        end
        if ((behind_block == "minecraft:air") or (behind_block == "minecraft:water") or (behind_block == "minecraft:lava")) then
            airblock_count = airblock_count + 1
        end
        if ((right_block == "minecraft:air") or (right_block == "minecraft:water") or (right_block == "minecraft:lava")) then
            airblock_count = airblock_count + 1
        end

        if airblock_count <= 2 then
            print("In a hole. Escaping")
            if ((behind_block == "minecraft:air") or (behind_block == "minecraft:water") or (behind_block == "minecraft:lava")) then
                sendCommand(target_turtle,"turtle.back()")
            elseif ((left_block == "minecraft:air") or (left_block == "minecraft:water") or (left_block == "minecraft:lava")) then
                sendCommand(target_turtle,"turtle.turnRight()")
                sendCommand(target_turtle,"turtle.back()")
            elseif ((right_block == "minecraft:air") or (right_block == "minecraft:water") or (right_block == "minecraft:lava")) then
                escape_trajectory = "right"
                sendCommand(target_turtle,"turtle.turnLeft()")
                sendCommand(target_turtle,"turtle.back()")
            elseif ((up_block == "minecraft:air") or (up_block == "minecraft:water") or (up_block == "minecraft:lava")) then
                sendCommand(target_turtle,"turtle.up()")
            elseif ((down_block == "minecraft:air") or (down_block == "minecraft:water") or (down_block == "minecraft:lava")) then
                sendCommand(target_turtle,"turtle.down()")
            elseif ((forward_block == "minecraft:air") or (forward_block == "minecraft:water") or (forward_block == "minecraft:lava")) then
                sendCommand(target_turtle,"turtle.forward()")
            end
        end
    end
end

function getSurroundingBlocks(target_turtle, print_results)
    coords, command_results = sendCommand(target_turtle,"turtle.inspectUp()")
    up_block = command_results[3][2]
    coords, command_results = sendCommand(target_turtle,"turtle.inspectDown()")
    down_block = command_results[3][2]
    coords, command_results = sendCommand(target_turtle,"turtle.inspect()")
    forward_block = command_results[3][2]
    sendCommand(target_turtle,"turtle.turnLeft()")
    coords, command_results = sendCommand(target_turtle,"turtle.inspect()")
    left_block = command_results[3][2]
    sendCommand(target_turtle,"turtle.turnLeft()")
    coords, command_results = sendCommand(target_turtle,"turtle.inspect()")
    behind_block = command_results[3][2]
    sendCommand(target_turtle,"turtle.turnLeft()")
    coords, command_results = sendCommand(target_turtle,"turtle.inspect()")
    right_block = command_results[3][2]
    sendCommand(target_turtle,"turtle.turnLeft()")

    if print_results == 1 then
        io.write("up_block: ")
        print(up_block)
        io.write("down_block: ")
        print(down_block)
        io.write("forward_block: ")
        print(forward_block)
        io.write("left_block: ")
        print(left_block)
        io.write("behind_block: ")
        print(behind_block)
        io.write("right_block: ")
        print(right_block)
    end

    return up_block, down_block, forward_block, left_block, behind_block, right_block
end

function sendCommand(target_turtle,command)
    os.sleep(sendCommand_delay)
    rednet.broadcast(command, "to_turtle" .. target_turtle)
    sender_id, command_results, protocol = rednet.receive("from_turtle" .. target_turtle,600)
    coords = extract_coordinates(command_results[1][2])
    return coords, command_results
end

function extract_coordinates(input_string)
    local x, y, z = input_string:match("([-]?%d+%.?%d*),%s*([-]?%d+%.?%d*),%s*([-]?%d+%.?%d*)")
    if x and y and z then
        x = tonumber(x)
        y = tonumber(y)
        z = tonumber(z)
        return (vector.new(x,y,z))
    else
        return nil, nil, nil
    end
end

function sendCoordinateCheck(target_turtle)
    local current_turtle_vector = sendCommand(target_turtle,"xyz_ping")
    if current_turtle_vector == nill then
        return
    end
    return current_turtle_vector
end

function sendChunkyCoordinateCheck(target_turtle)
    rednet.broadcast(command, "to_turtle" .. getMinerForChunky(target_turtle))
    sender_id, command_results, protocol = rednet.receive("from_turtle" .. target_turtle,30)
    coords = extract_coordinates(command_results[1][2])
    return coords
end

function getCardinalDirection(target_turtle)
    current_direction = ""
        while current_direction == "" do
            local current_turtle_vector = sendCoordinateCheck(target_turtle)
            local initial_diff = vector.new(0,0,0) - current_turtle_vector
            local new_turtle_vector = sendCommand(target_turtle,"turtle.forward()")
            local new_diff = vector.new(0,0,0) - new_turtle_vector
            if initial_diff == new_diff then
                stuck = true
                print("turtle is stuck. cannot determine direction")
            else 
                current_direction_diff = new_diff - initial_diff
                current_direction = resolveCardinalDirection(current_turtle_vector,current_direction_diff.x,current_direction_diff.z)
            end
            sendCommand(target_turtle,"turtle.back()")
        end
    return current_direction
end

function resolveCardinalDirection(current_turtle_vector,dx,dz)
    direction = ""
    graph_quadrant = 0
    if ((current_turtle_vector.x < 0) and (current_turtle_vector.z < 0)) then
        graph_quadrant = 1
    elseif ((current_turtle_vector.x > 0) and (current_turtle_vector.z < 0)) then
        graph_quadrant = 2
    elseif ((current_turtle_vector.x < 0) and (current_turtle_vector.z > 0)) then
        graph_quadrant = 3
    elseif ((current_turtle_vector.x > 0) and (current_turtle_vector.z > 0)) then
        graph_quadrant = 4
    end

    if ((graph_quadrant == 1) or (graph_quadrant == 0)) then
        if dz == 1 then
            direction = "north"
        elseif dx == -1 then
            direction = "east"
        elseif dz == -1 then
            direction = "south"
        elseif dx == 1 then
            direction = "west"
        end
    elseif(graph_quadrant == 2) then
        if dz == 1 then
            direction = "north"
        elseif dx == -1 then
            direction = "east"
        elseif dz == -1 then
            direction = "south"
        elseif dx == 1 then
            direction = "west"
        end
    elseif(graph_quadrant == 3) then
        if dz == 1 then
            direction = "north"
        elseif dx == -1 then
            direction = "east"
        elseif dz == -1 then
            direction = "south"
        elseif dx == 1 then
            direction = "west"
        end
    elseif(graph_quadrant == 4) then
        if dz == 1 then
            direction = "north"
        elseif dx == -1 then
            direction = "east"
        elseif dz == -1 then
            direction = "south"
        elseif dx == 1 then
            direction = "west"
        end
    end
    return direction
end

function goToCoordinates(target_turtle,tx,ty,tz,wrap,steps,pause)
    local stuck = false
    local hard_stuck = false
    local initial_direction = getCardinalDirection(target_turtle)
    local current_direction = initial_direction
    local current_turtle_vector = sendCoordinateCheck(target_turtle)
    local target_coordinates = vector.new(tx,ty,tz)
    local current_diff = target_coordinates - current_turtle_vector
    local previous_diff = current_diff
    local hard_stuck_diff = previous_diff
    local moves_list = {}
    local bouncing_turtle_check = {}
    local path_steps = 0
    local path_length = 3
    table.insert(bouncing_turtle_check,current_turtle_vector)

    while (target_coordinates ~= current_turtle_vector) do
        if pause == 1 then
            io.write("")
            io.read()
        end
        if steps == 1 then
            io.write("Starting Coordinates: ")
            print(current_turtle_vector)
            print("begin moving along Y-axis")
        end
        local path_steps = 0
        while ((current_diff.y ~=0) and (path_steps <= (math.floor(path_length / 1)))) do
            if pause == 1 then
                io.write("")
                io.read()
            end
            if steps == 1 then
                io.write("Current Coordinates: ")
                print(current_turtle_vector)
            end
            if current_diff.y > 0 then
                sendCommand(target_turtle,"turtle.up()")
                path_steps = path_steps + 1
            end
            if current_diff.y < 0 then
                sendCommand(target_turtle,"turtle.down()")
                path_steps = path_steps + 1
            end
            hard_stuck_diff = previous_diff
            previous_diff = current_diff
            current_turtle_vector = sendCoordinateCheck(target_turtle)
            table.insert(bouncing_turtle_check,current_turtle_vector)
            current_diff = target_coordinates - current_turtle_vector

            if(current_diff == previous_diff) then
                stuck = true
                print("turtle is stuck")
                break
            elseif(current_diff ~= previous_diff) then
                stuck = false
            end
        end
        if steps == 1 then
            io.write("Starting Coordinates: ")
            print(current_turtle_vector)
            print("begin moving along X-axis and Z-axis")
        end
        for i = 1, 2 do
            local path_steps = 0
            while ((current_diff.x ~= 0 or current_diff.z ~= 0) and (path_steps <= path_length)) do
                if pause == 1 then
                    io.write("")
                    io.read()
                end
                if steps == 1 then
                    io.write("Current Coordinates: ")
                    print(current_turtle_vector)
                end
                correct_direction = false
                go_north = false
                go_west = false
                go_south = false
                go_east = false
                if current_diff.z < 0 then
                    go_north = true  
                end
                if current_diff.x < 0 then
                    go_west = true
                end
                if current_diff.z > 0 then
                    go_south = true
                end
                if current_diff.x > 0 then
                    go_east = true
                end
                if((current_direction == "north" and go_north == true) or (current_direction == "west" and go_west == true) or (current_direction == "east" and go_east == true) or (current_direction == "south" and go_south == true)) then
                    correct_direction = true
                end
                if(path_steps == (math.floor(path_length / 2))) then
                    correct_direction = false
                end
                while (correct_direction == false) do 
                    if (current_direction == "north" and go_west) or (current_direction == "west" and go_south) or (current_direction == "south" and go_east) or (current_direction == "east" and go_north) then
                        sendCommand(target_turtle,"turtle.turnLeft()")
                        correct_direction = true
                    elseif (current_direction == "north" and go_east) or (current_direction == "east" and go_south) or (current_direction == "south" and go_west) or (current_direction == "west" and go_north) then
                        sendCommand(target_turtle,"turtle.turnRight()")
                        correct_direction = true
                    elseif ((current_direction == "north" and go_north == true) or (current_direction == "west" and go_west == true) or (current_direction == "east" and go_east == true) or (current_direction == "south" and go_south == true)) then
                        correct_direction = true
                    else
                        sendCommand(target_turtle,"turtle.turnLeft()")
                        sendCommand(target_turtle,"turtle.turnLeft()")
                        correct_direction = true
                    end
                end
                sendCommand(target_turtle,"turtle.forward()")
                path_steps = path_steps + 1
                hard_stuck_diff = previous_diff
                previous_diff = current_diff
                previous_direction = current_direction
                current_turtle_vector = sendCoordinateCheck(target_turtle)
                table.insert(bouncing_turtle_check,current_turtle_vector)
                current_diff = target_coordinates - current_turtle_vector
                current_direction_diff = current_diff - previous_diff
                current_direction = resolveCardinalDirection(current_turtle_vector,current_direction_diff.x,current_direction_diff.z)
                if(current_diff == previous_diff) then
                    stuck = true
                    print("turtle is stuck")
                    current_direction = previous_direction
                    break
                elseif(current_diff ~= previous_diff) then
                    stuck = false
                end
            end
        end

        if (tostring(bouncing_turtle_check[#bouncing_turtle_check]) == tostring(bouncing_turtle_check[#bouncing_turtle_check-2])) then
            hard_stuck = true
            print("turtle is currently bouncing")
            current_direction = previous_direction
        end

        if hard_stuck == true then
            if(wrap == 1) then
                hard_stuck = wrapAroundObject(target_turtle,hard_stuck,tx,ty,tz)
            end
        end
    end

    if pause == 1 then
        io.write("")
        io.read()
    end
    if steps == 1 then
        io.write("Ending Coordinates: ")
        print(current_turtle_vector)
    end
end

function wrapAroundObject(target_turtle,hard_stuck,tx,ty,tz)
    while hard_stuck == true do
        print("Escape Hole")
        escapeHole(target_turtle)
        print("Begin moving around obstacle")
        local target_coordinates = vector.new(tx,ty,tz)
        current_turtle_vector = sendCoordinateCheck(target_turtle)
        current_diff = target_coordinates - current_turtle_vector
        local local_minima_coords = current_turtle_vector
        local local_minima_total_distance = math.abs(current_diff.x) + math.abs(current_diff.y) + math.abs(current_diff.z)
        local current_turtle_vector_total_distance = math.abs(current_diff.x) + math.abs(current_diff.y) + math.abs(current_diff.z)
        local up_block, down_block, forward_block, left_block, behind_block, right_block = getSurroundingBlocks(target_turtle)
        local step_counter = 0
        local steps_threshold = 7
        local break_loop_count = 50
        local moves_list = {}

        if(last_solution_axis) then
            prefered_axis = last_solution_axis
        elseif not (last_solution_axis) then
            prefered_axis = "horizontal"
        end
        
        while (local_minima_total_distance <= current_turtle_vector_total_distance) do
            if (prefered_axis == "horizontal") then

                if (local_minima_total_distance <= current_turtle_vector_total_distance) then
                    print("Begin wrapping around to the left")
                    moves_list = {}
                    step_counter = 0
                    loop_count = 0
                    
                    while ((local_minima_total_distance <= current_turtle_vector_total_distance) and (step_counter < steps_threshold)) do
                        if (((left_block == "minecraft:air") or (behind_block == "minecraft:air")) and (local_minima_total_distance <= current_turtle_vector_total_distance) and (step_counter < steps_threshold)) then
                            while forward_block ~= "minecraft:air" and ((local_minima_total_distance <= current_turtle_vector_total_distance) and (step_counter < steps_threshold)) do
                                sendCommand(target_turtle,"turtle.turnLeft()")
                                table.insert(moves_list,"left")
                                up_block, down_block, forward_block, left_block, behind_block, right_block = getSurroundingBlocks(target_turtle)
                            end
                            while ((forward_block == "minecraft:air") and (local_minima_total_distance <= current_turtle_vector_total_distance) and (step_counter < steps_threshold)) do
                                sendCommand(target_turtle,"turtle.forward()")
                                table.insert(moves_list,"forward")
                                step_counter = step_counter + 1
                                current_turtle_vector = sendCoordinateCheck(target_turtle)
                                current_diff = target_coordinates - current_turtle_vector
                                current_turtle_vector_total_distance = math.abs(current_diff.x) + math.abs(current_diff.y) + math.abs(current_diff.z)
                                up_block, down_block, forward_block, left_block, behind_block, right_block = getSurroundingBlocks(target_turtle)
                                if right_block == "minecraft:air" then
                                    sendCommand(target_turtle,"turtle.turnRight()")
                                    table.insert(moves_list,"right")
                                    up_block, down_block, forward_block, left_block, behind_block, right_block = getSurroundingBlocks(target_turtle)
                                end
                            end

                            loop_count = loop_count + 1
                            if loop_count > break_loop_count then
                                break
                            end

                        end

                        loop_count = loop_count + 1
                            if loop_count > break_loop_count then
                                break
                            end

                    end
                end

                if (local_minima_total_distance <= current_turtle_vector_total_distance) then
                    print("Left Wrap Failed - Returnig to local minima coordinate")
                    reverseMoves(target_turtle,moves_list)
                    up_block, down_block, forward_block, left_block, behind_block, right_block = getSurroundingBlocks(target_turtle)
                end

                if (local_minima_total_distance <= current_turtle_vector_total_distance) then
                    print("Begin wrapping around to the right")
                    moves_list = {}
                    step_counter = 0
                    while ((local_minima_total_distance <= current_turtle_vector_total_distance) and (step_counter < steps_threshold)) do
                        if (((right_block == "minecraft:air") or (behind_block == "minecraft:air")) and (local_minima_total_distance <= current_turtle_vector_total_distance) and (step_counter < steps_threshold)) then
                            while forward_block ~= "minecraft:air" and ((local_minima_total_distance <= current_turtle_vector_total_distance) and (step_counter < steps_threshold)) do
                                sendCommand(target_turtle,"turtle.turnRight()")
                                table.insert(moves_list,"right")
                                up_block, down_block, forward_block, left_block, behind_block, right_block = getSurroundingBlocks(target_turtle)
                            end
                            while ((forward_block == "minecraft:air") and (local_minima_total_distance <= current_turtle_vector_total_distance) and (step_counter < steps_threshold)) do
                                sendCommand(target_turtle,"turtle.forward()")
                                table.insert(moves_list,"forward")
                                step_counter = step_counter + 1
                                current_turtle_vector = sendCoordinateCheck(target_turtle)
                                current_diff = target_coordinates - current_turtle_vector
                                current_turtle_vector_total_distance = math.abs(current_diff.x) + math.abs(current_diff.y) + math.abs(current_diff.z)
                                up_block, down_block, forward_block, left_block, behind_block, right_block = getSurroundingBlocks(target_turtle)
                                if left_block == "minecraft:air" then
                                    sendCommand(target_turtle,"turtle.turnLeft()")
                                    table.insert(moves_list,"left")
                                    up_block, down_block, forward_block, left_block, behind_block, right_block = getSurroundingBlocks(target_turtle)
                                end
                            end

                            loop_count = loop_count + 1
                            if loop_count > break_loop_count then
                                break
                            end

                        end

                        loop_count = loop_count + 1
                            if loop_count > break_loop_count then
                                break
                            end

                    end
                end

                if (local_minima_total_distance <= current_turtle_vector_total_distance) then
                    print("Right Wrap Failed - Returnig to local minima coordinate")
                    reverseMoves(target_turtle,moves_list)
                    up_block, down_block, forward_block, left_block, behind_block, right_block = getSurroundingBlocks(target_turtle)
                end

                if (local_minima_total_distance <= current_turtle_vector_total_distance) then
                    print("switch to vertical wrapping")
                    prefered_axis = "vertical"
                end

                if not (local_minima_total_distance <= current_turtle_vector_total_distance) then
                    last_solution_axis = "horizontal"
                end

            end

            if (prefered_axis == "vertical") then

                if (local_minima_total_distance <= current_turtle_vector_total_distance) then
                    print("Begin wrapping around the top")
                    moves_list = {}
                    step_counter = 0
                    while ((local_minima_total_distance <= current_turtle_vector_total_distance) and (step_counter < steps_threshold)) do
                        if (((up_block == "minecraft:air") or (behind_block == "minecraft:air")) and (local_minima_total_distance <= current_turtle_vector_total_distance) and (step_counter < steps_threshold)) then
                            while up_block ~= "minecraft:air" and ((local_minima_total_distance <= current_turtle_vector_total_distance) and (step_counter < steps_threshold)) do
                                sendCommand(target_turtle,"turtle.back()")
                                table.insert(moves_list,"back")
                                step_counter = step_counter + 1
                                up_block, down_block, forward_block, left_block, behind_block, right_block = getSurroundingBlocks(target_turtle)

                                loop_count = loop_count + 1
                                if loop_count > break_loop_count then
                                    break
                                end

                            end
                            while ((up_block == "minecraft:air") and (local_minima_total_distance <= current_turtle_vector_total_distance) and (step_counter < steps_threshold)) do
                                sendCommand(target_turtle,"turtle.up()")
                                table.insert(moves_list,"up")
                                step_counter = step_counter + 1
                                current_turtle_vector = sendCoordinateCheck(target_turtle)
                                current_diff = target_coordinates - current_turtle_vector
                                current_turtle_vector_total_distance = math.abs(current_diff.x) + math.abs(current_diff.y) + math.abs(current_diff.z)
                                up_block, down_block, forward_block, left_block, behind_block, right_block = getSurroundingBlocks(target_turtle)
                                while ((forward_block == "minecraft:air") and (local_minima_total_distance <= current_turtle_vector_total_distance) and (step_counter < steps_threshold)) do
                                    sendCommand(target_turtle,"turtle.forward()")
                                    table.insert(moves_list,"forward")
                                    step_counter = step_counter + 1
                                    current_turtle_vector = sendCoordinateCheck(target_turtle)
                                    current_diff = target_coordinates - current_turtle_vector
                                    current_turtle_vector_total_distance = math.abs(current_diff.x) + math.abs(current_diff.y) + math.abs(current_diff.z)
                                    up_block, down_block, forward_block, left_block, behind_block, right_block = getSurroundingBlocks(target_turtle)
                                    while ((down_block == "minecraft:air") and (local_minima_total_distance <= current_turtle_vector_total_distance) and (step_counter < steps_threshold)) do
                                        sendCommand(target_turtle,"turtle.down()")
                                        table.insert(moves_list,"down")
                                        step_counter = step_counter + 1
                                        current_turtle_vector = sendCoordinateCheck(target_turtle)
                                        current_diff = target_coordinates - current_turtle_vector
                                        current_turtle_vector_total_distance = math.abs(current_diff.x) + math.abs(current_diff.y) + math.abs(current_diff.z)
                                        up_block, down_block, forward_block, left_block, behind_block, right_block = getSurroundingBlocks(target_turtle)
                                    end
                                end
                            end
                            loop_count = loop_count + 1
                            if loop_count > break_loop_count then
                                break
                            end
                        end
                    end

                    loop_count = loop_count + 1
                            if loop_count > break_loop_count then
                                break
                            end

                end

                if (local_minima_total_distance <= current_turtle_vector_total_distance) then
                    print("Top Wrap Failed - Returnig to local minima coordinate")
                    reverseMoves(target_turtle,moves_list)
                    up_block, down_block, forward_block, left_block, behind_block, right_block = getSurroundingBlocks(target_turtle)
                end

                if (local_minima_total_distance <= current_turtle_vector_total_distance) then
                    print("Begin wrapping around the bottom")
                    moves_list = {}
                    step_counter = 0
                    while ((local_minima_total_distance <= current_turtle_vector_total_distance) and (step_counter < steps_threshold)) do
                        if (((down_block == "minecraft:air") or (behind_block == "minecraft:air")) and (local_minima_total_distance <= current_turtle_vector_total_distance) and (step_counter < steps_threshold)) then
                            while down_block ~= "minecraft:air" and ((local_minima_total_distance <= current_turtle_vector_total_distance) and (step_counter < steps_threshold)) do
                                sendCommand(target_turtle,"turtle.back()")
                                table.insert(moves_list,"back")
                                step_counter = step_counter + 1
                                up_block, down_block, forward_block, left_block, behind_block, right_block = getSurroundingBlocks(target_turtle)
                                loop_count = loop_count + 1
                                if loop_count > break_loop_count then
                                    break
                                end
                            end
                            while ((down_block == "minecraft:air") and (local_minima_total_distance <= current_turtle_vector_total_distance) and (step_counter < steps_threshold)) do
                                sendCommand(target_turtle,"turtle.down()")
                                table.insert(moves_list,"down")
                                step_counter = step_counter + 1
                                current_turtle_vector = sendCoordinateCheck(target_turtle)
                                current_diff = target_coordinates - current_turtle_vector
                                current_turtle_vector_total_distance = math.abs(current_diff.x) + math.abs(current_diff.y) + math.abs(current_diff.z)
                                up_block, down_block, forward_block, left_block, behind_block, right_block = getSurroundingBlocks(target_turtle)
                                while ((forward_block == "minecraft:air") and (local_minima_total_distance <= current_turtle_vector_total_distance) and (step_counter < steps_threshold)) do
                                    sendCommand(target_turtle,"turtle.forward()")
                                    table.insert(moves_list,"forward")
                                    step_counter = step_counter + 1
                                    current_turtle_vector = sendCoordinateCheck(target_turtle)
                                    current_diff = target_coordinates - current_turtle_vector
                                    current_turtle_vector_total_distance = math.abs(current_diff.x) + math.abs(current_diff.y) + math.abs(current_diff.z)
                                    up_block, down_block, forward_block, left_block, behind_block, right_block = getSurroundingBlocks(target_turtle)
                                    while ((up_block == "minecraft:air") and (local_minima_total_distance <= current_turtle_vector_total_distance) and (step_counter < steps_threshold)) do
                                        sendCommand(target_turtle,"turtle.up()")
                                        table.insert(moves_list,"up")
                                        step_counter = step_counter + 1
                                        current_turtle_vector = sendCoordinateCheck(target_turtle)
                                        current_diff = target_coordinates - current_turtle_vector
                                        current_turtle_vector_total_distance = math.abs(current_diff.x) + math.abs(current_diff.y) + math.abs(current_diff.z)
                                        up_block, down_block, forward_block, left_block, behind_block, right_block = getSurroundingBlocks(target_turtle)
                                    end
                                end
                            end
                            loop_count = loop_count + 1
                            if loop_count > break_loop_count then
                                break
                            end
                        end
                    end

                    loop_count = loop_count + 1
                            if loop_count > break_loop_count then
                                break
                            end

                end

                if (local_minima_total_distance <= current_turtle_vector_total_distance) then
                    print("Bottom Wrap Failed - Returnig to local minima coordinate")
                    reverseMoves(target_turtle,moves_list)
                    up_block, down_block, forward_block, left_block, behind_block, right_block = getSurroundingBlocks(target_turtle)
                end

                if (local_minima_total_distance <= current_turtle_vector_total_distance) then
                    print("switch to horizontal wrapping")
                    prefered_axis = "horizontal"
                end

                if not (local_minima_total_distance <= current_turtle_vector_total_distance) then
                    last_solution_axis = "vertical"
                end
            end

            if(hard_stuck == true) then
                break
            end
        end

        hard_stuck_diff = previous_diff
        previous_diff = current_diff
        previous_direction = current_direction
        current_direction = getCardinalDirection(target_turtle)
        current_turtle_vector = sendCoordinateCheck(target_turtle)
        current_diff = target_coordinates - current_turtle_vector

        if not (local_minima_total_distance <= current_turtle_vector_total_distance) then
            hard_stuck = false
            print("successfully wrapped around object")
        end

        if (local_minima_total_distance <= current_turtle_vector_total_distance) then
            hard_stuck = true
            print("failed to wrap around object.")
            break
        end
    end
    return hard_stuck
end

function getValidNumberInput()
    while true do
        io.write("Enter the loop count (a number): ")
        local input = io.read()
        local number = tonumber(input)
        if number then
            return number
        else
            print("Error: Input must be a valid number.")
        end
    end
end

function toggleTurtleMiningMode(target_turtle)
    coords, command_results = sendCommand(target_turtle,"toggleMiningMode()")
    mining_mode = command_results[3][2]
    return mining_mode
end

function disableTurtleMiningMode(target_turtle)
    coords, command_results = sendCommand(target_turtle,"disableMiningMode()")
    mining_mode = command_results[3][2]
    return mining_mode
end

function calculateNWtoSESnakePath(center_of_mine,turtle_number,divisor)
    nw_mine_perimeter = {x = (center_of_mine.x - (3 * 16)) , y = center_of_mine.y , z = (center_of_mine.z - (3 * 16))}
    ne_mine_perimeter = {x = (center_of_mine.x + (3 * 16)) , y = center_of_mine.y , z = (center_of_mine.z - (3 * 16))}
    sw_mine_perimeter = {x = (center_of_mine.x - (3 * 16)) , y = center_of_mine.y , z = (center_of_mine.z + (3 * 16))}
    se_mine_perimeter = {x = (center_of_mine.x + (3 * 16)) , y = center_of_mine.y , z = (center_of_mine.z + (3 * 16))}
    nw_mine_perimeter_vector = vector.new(nw_mine_perimeter.x,nw_mine_perimeter.y,nw_mine_perimeter.z)
    ne_mine_perimeter_vector = vector.new(ne_mine_perimeter.x,ne_mine_perimeter.y,ne_mine_perimeter.z)
    sw_mine_perimeter_vector = vector.new(sw_mine_perimeter.x,sw_mine_perimeter.y,sw_mine_perimeter.z)
    se_mine_perimeter_vector = vector.new(se_mine_perimeter.x,se_mine_perimeter.y,se_mine_perimeter.z)
    horizontal_distance_vector = nw_mine_perimeter_vector - ne_mine_perimeter_vector
    vertical_distance_vector = nw_mine_perimeter_vector - sw_mine_perimeter_vector
    snake_path =  {}
    shift = 0
    for i = 4, (math.abs(vertical_distance_vector.z) * 2) + 4, 4 do
        s = (i / 4) + shift - 1
        snake_path[i-3] = nw_mine_perimeter_vector + vector.new(0,0,s)
        snake_path[i-2] = nw_mine_perimeter_vector - horizontal_distance_vector + vector.new(0,0,s)
        snake_path[i-1] = nw_mine_perimeter_vector - horizontal_distance_vector + vector.new(0,0,s+1)
        snake_path[i] = nw_mine_perimeter_vector + vector.new(0,0,s+1)
        shift = shift + 1
    end
    divided_snake_path = {}
    for k = 1, divisor do
        divided_snake_path[k] = {}
        for j = 1, #snake_path do
            divided_snake_path[k][j] = vector.new(snake_path[j].x, snake_path[j].y, snake_path[j].z + (divisor * (k - 1)))
        end
        for j = #divided_snake_path[k], 1, -1 do
            if divided_snake_path[k][j].z > sw_mine_perimeter_vector.z then
                table.remove(divided_snake_path[k], j)
            end
        end
    end
    return divided_snake_path[turtle_number]
end

function resumeSnakeAtCoord(snake_path_array,resume_at_coord)
    resume_snake_array = {}
    for j = 1, #snake_path_array, 1 do
        if snake_path_array[j] == resume_at_coord then
            resume_snake_array_index = j
        end
    end
    i = 1
    for k = resume_snake_array_index, #snake_path_array, 1 do
        resume_snake_array[i] = snake_path_array[k]
        i = i + 1
    end
    return(resume_snake_array)
end

function calculateSWtoNESnakePath(center_of_mine, turtle_number, divisor)
    nw_mine_perimeter = {x = (center_of_mine.x - (3 * 16)) , y = center_of_mine.y , z = (center_of_mine.z - (3 * 16))}
    ne_mine_perimeter = {x = (center_of_mine.x + (3 * 16)) , y = center_of_mine.y , z = (center_of_mine.z - (3 * 16))}
    sw_mine_perimeter = {x = (center_of_mine.x - (3 * 16)) , y = center_of_mine.y , z = (center_of_mine.z + (3 * 16))}
    se_mine_perimeter = {x = (center_of_mine.x + (3 * 16)) , y = center_of_mine.y , z = (center_of_mine.z + (3 * 16))}
    nw_mine_perimeter_vector = vector.new(nw_mine_perimeter.x,nw_mine_perimeter.y,nw_mine_perimeter.z)
    ne_mine_perimeter_vector = vector.new(ne_mine_perimeter.x,ne_mine_perimeter.y,ne_mine_perimeter.z)
    sw_mine_perimeter_vector = vector.new(sw_mine_perimeter.x,sw_mine_perimeter.y,sw_mine_perimeter.z)
    se_mine_perimeter_vector = vector.new(se_mine_perimeter.x,se_mine_perimeter.y,se_mine_perimeter.z)
    horizontal_distance_vector = nw_mine_perimeter_vector - ne_mine_perimeter_vector
    vertical_distance_vector = nw_mine_perimeter_vector - sw_mine_perimeter_vector
    snake_path =  {}
    shift = 0
    for i = 4, (math.abs(horizontal_distance_vector.x) * 2) + 4, 4 do
        s = (i / 4) + shift - 1
        snake_path[i-3] = sw_mine_perimeter_vector + vector.new(s,0,0)
        snake_path[i-2] = sw_mine_perimeter_vector + vertical_distance_vector + vector.new(s,0,0)
        snake_path[i-1] = sw_mine_perimeter_vector + vertical_distance_vector + vector.new(s+1,0,0)
        snake_path[i] = sw_mine_perimeter_vector + vector.new(s+1,0,0)
        shift = shift + 1
    end
    divided_snake_path = {}
    for k = 1, divisor do
        divided_snake_path[k] = {}
        for j = 1, #snake_path do
            divided_snake_path[k][j] = vector.new(snake_path[j].x + (divisor * (k - 1)), snake_path[j].y, snake_path[j].z)
        end
        for j = #divided_snake_path[k], 1, -1 do
            if divided_snake_path[k][j].x > ne_mine_perimeter_vector.x then
                table.remove(divided_snake_path[k], j)
            end
        end
    end
    return divided_snake_path[turtle_number]
end

function multipointPaths(turtle_number,multipoint_path_name)
    multipoint_path = {}
    if multipoint_path_name == "fuel" then
        multipoint_path[1] = {x = -8620 , y = 15 , z = -4715}
        multipoint_path[2] = {x = -8620 , y = 15 , z = -4716}
    elseif multipoint_path_name == "storage" then
        multipoint_path[1] = {x = -8620 , y = 15 , z = -4710}
        multipoint_path[2] = {x = -8620 , y = 15 , z = -4709}
    elseif multipoint_path_name == "home" then
        multipoint_path[1] = {x = -8615 , y = 15 , z = -4719}
    end
    return multipoint_path
end

function multiPointPathingTask(target_turtle, multipoint_path_name)
    print()
    io.write("Target Turtle ID: ", target_turtle,"\n")
    current_direction = getCardinalDirection(target_turtle)
    io.write("Current Direction: ", current_direction,"\n")
    current_coordinates = sendCoordinateCheck(target_turtle)
    io.write("Current Coordinates: ", current_coordinates,"\n")
    io.write("Current Path: ", multipoint_path_name,"\n")
    multipoint_path = {}
    multipoint_path = multipointPaths(turtle_number,multipoint_path_name)
    for i, point in ipairs(multipoint_path) do
        print("Going to: " .. point.x .. ',' .. point.y .. ',' .. point.z)
        goToCoordinates(target_turtle,point.x,point.y,point.z,1,1,0)
        print("Task is " .. (i / #multipoint_path) .. "% completed")
    end
    print("Arrived at destination")
    current_direction = getCardinalDirection(target_turtle)
    io.write("Current Direction: ", current_direction,"\n")
    io.write("Current Coordinates: ", current_coordinates.x .. ',' .. current_coordinates.y .. ',' .. current_coordinates.z,"\n")
    io.write("Current Coordinates: ", current_coordinates,"\n")
    io.write("Press Enter To Close...")
    io.read()
end

function singlePointPathingTask(target_turtle, target_coordinates)
    print()
    io.write("Target Turtle ID: ", target_turtle,"\n")
    current_direction = getCardinalDirection(target_turtle)
    io.write("Current Direction: ", current_direction,"\n")
    current_coordinates = sendCoordinateCheck(target_turtle)
    io.write("Current Coordinates: ", current_coordinates.x .. ',' .. current_coordinates.y .. ',' .. current_coordinates.z,"\n")
    io.write("Target Coordinates: ", target_coordinates.x .. ',' .. target_coordinates.y .. ',' .. target_coordinates.z,"\n")
    goToCoordinates(target_turtle,target_coordinates.x,target_coordinates.y,target_coordinates.z,1,1,0)
    print("Arrived at destination")
    current_direction = getCardinalDirection(target_turtle)
    io.write("Current Direction: ", current_direction,"\n")
    current_coordinates = sendCoordinateCheck(target_turtle)
    io.write("Current Coordinates: ", current_coordinates.x .. ',' .. current_coordinates.y .. ',' .. current_coordinates.z,"\n")
    io.write("Press Enter To Close...")
    io.read()
end

function multiPointMiningTask(target_turtle, center_of_mine)
    turtle_number = 1
    divisor = 1
    print()
    io.write("Target Turtle ID: ", target_turtle,"\n")
    current_direction = getCardinalDirection(target_turtle)
    io.write("Current Direction: ", current_direction,"\n")
    current_coordinates = sendCoordinateCheck(target_turtle)
    io.write("Current Coordinates: ", current_coordinates.x .. ',' .. current_coordinates.y .. ',' .. current_coordinates.z,"\n")
    mining_mode = toggleTurtleMiningMode(target_turtle)
    io.write("Mining Mode: ", mining_mode,"\n")
    io.write("Current Path: ", center_of_mine.x.. ',' ..center_of_mine.y.. ',' ..center_of_mine.z,"\n")
    multipoint_path = calculateNWtoSESnakePath(center_of_mine, 1, 1)
    for i, point in ipairs(multipoint_path) do
        print("Going to: " .. point.x .. ',' .. point.y .. ',' .. point.z)
        goToCoordinates(target_turtle,point.x,point.y,point.z,0,0,0)
        sendCommand(target_turtle,"dropJunk()")
        print("Current layer is " .. math.ceil(100 * (i / #multipoint_path)) .. "% completed")
    end
    print("finished mining")
    current_direction = getCardinalDirection(target_turtle)
    io.write("Current Direction: ", current_direction,"\n")
    current_coordinates = sendCoordinateCheck(target_turtle)
    io.write("Current Coordinates: ", current_coordinates.x .. ',' .. current_coordinates.y .. ',' .. current_coordinates.z,"\n")
    io.write("Press Enter To Close...")
    io.read()
end

function multiLayerMiningTask(target_turtle, center_of_mine, resume_at_coord, storage_coord)
    turtle_number = 1
    divisor = 1
    y_lower_limit = -64
    starting_center_of_mine = center_of_mine
    start_time = os.clock()
    print()
    io.write("Target Turtle ID: ", target_turtle,"\n")
    current_direction = getCardinalDirection(target_turtle)
    io.write("Current Direction: ", current_direction,"\n")
    current_coordinates = sendCoordinateCheck(target_turtle)
    io.write("Current Coordinates: ", current_coordinates.x .. ',' .. current_coordinates.y .. ',' .. current_coordinates.z,"\n")
    number_of_layers = current_coordinates.y - y_lower_limit
    mining_mode = toggleTurtleMiningMode(target_turtle)
    io.write("Mining Mode: ", mining_mode,"\n")
    io.write("Center of Mine: ", center_of_mine.x.. ',' ..center_of_mine.y.. ',' ..center_of_mine.z,"\n")
    for k = 1, number_of_layers, 1 do
        if (k == 1 and resume_at_coord ~= 0) then
            print("resuming layer")
            multipoint_path = calculateNWtoSESnakePath(center_of_mine, 1, 1)
            snake_path_array = resumeSnakeAtCoord(multipoint_path,resume_at_coord)
            multipoint_path = snake_path_array
        elseif (k ~= 1 or resume_at_coord == 0) then
            print("starting on fresh layer")
            multipoint_path = calculateNWtoSESnakePath(center_of_mine, 1, 1)
        end
        for i, point in ipairs(multipoint_path) do
            if i == 1 then
                layer_start = point
                print("Going to: " .. starting_center_of_mine.x .. ',' .. starting_center_of_mine.y .. ',' .. starting_center_of_mine.z)
                goToCoordinates(target_turtle,starting_center_of_mine.x,starting_center_of_mine.y,starting_center_of_mine.z,0,0,0)
                print("Depositing Items")
                depositMinedItems(target_turtle, starting_center_of_mine,storage_coord)
                print("Refueling")
                refuel(target_turtle, center_of_mine,storage_coord)
            end
            print("Going to: " .. point.x .. ',' .. point.y .. ',' .. point.z)
            goToCoordinates(target_turtle,point.x,point.y,point.z,0,0,0)
            sendCommand(target_turtle,"dropJunk()")
            print("Current layer is " .. math.ceil(100 * (i / #multipoint_path)) .. "% completed")
            end_time = os.clock()
            current_time_passed_minutes = math.ceil((end_time - start_time) / 60)
            print("Time Running: " .. current_time_passed_minutes .. " minutes")
        end
        print("Going to: " .. starting_center_of_mine.x .. ',' .. starting_center_of_mine.y .. ',' .. starting_center_of_mine.z)
        goToCoordinates(target_turtle,starting_center_of_mine.x,starting_center_of_mine.y,starting_center_of_mine.z,0,0,0)
        print("Depositing Items")
        depositMinedItems(target_turtle, starting_center_of_mine,storage_coord)
        print("Refueling")
        refuel(target_turtle, center_of_mine,storage_coord)
        print("Going to: " .. layer_start.x .. ',' .. layer_start.y .. ',' .. layer_start.z)
        goToCoordinates(target_turtle,layer_start.x,layer_start.y,layer_start.z,0,0,0)
        center_of_mine.y = center_of_mine.y - 3
    end
    print("finished mining")
    current_direction = getCardinalDirection(target_turtle)
    io.write("Current Direction: ", current_direction,"\n")
    current_coordinates = sendCoordinateCheck(target_turtle)
    io.write("Current Coordinates: ", current_coordinates.x .. ',' .. current_coordinates.y .. ',' .. current_coordinates.z,"\n")
    io.write("Press Enter To Close...")
    io.read()
end

function depositMinedItems(target_turtle, center_of_mine, storage_coord)
    goToCoordinates(target_turtle,storage_coord.x,storage_coord.y,(storage_coord.z + 2),0,0,0)
    goToCoordinates(target_turtle,storage_coord.x,storage_coord.y,(storage_coord.z + 1),0,0,0)
    coords, results = sendCommand(target_turtle,"turtle.forward()")
    if(coords.z == (storage_coord.z + 1)) then
        sendCommand(target_turtle,"depositItems()")
    end
    coords, results = sendCommand(target_turtle,"turtle.back()")
    goToCoordinates(target_turtle,center_of_mine.x,center_of_mine.y,center_of_mine.z,0,0,0)
end

function refuel(target_turtle, center_of_mine, storage_coord)
    low_fuel_threshold = 200000
    fuel_coords = storage_coord
    fuel_coords = fuel_coords + vector.new(0,1,0)
    coords, current_fuel_level = sendCommand(target_turtle,"turtle.getFuelLevel()")
    if (tonumber(current_fuel_level[2][2]) < low_fuel_threshold) then
        goToCoordinates(target_turtle,fuel_coords.x,fuel_coords.y,(fuel_coords.z + 2),0,0,0)
        goToCoordinates(target_turtle,fuel_coords.x,fuel_coords.y,(fuel_coords.z + 1),0,0,0)
        coords, results = sendCommand(target_turtle,"turtle.forward()")
        if(coords.z == (fuel_coords.z + 1)) then
            sendCommand(target_turtle,"turtle.suck()")
            sendCommand(target_turtle,"turtle.refuel()")
        end
        coords, results = sendCommand(target_turtle,"turtle.back()")
        goToCoordinates(target_turtle,center_of_mine.x,center_of_mine.y,center_of_mine.z,0,0,0)
    end
end

function findTask(target_turtle)
    chunky_turtles = getChunkyTurtles()
    target_turtle_is_chunky = false
    for i = 1, #chunky_turtles do
        if (target_turtle == chunky_turtles[i]) then
            target_turtle_is_chunky = true
        end
    end
    if target_turtle_is_chunky == true then
        current_coordinates = sendChunkyCoordinateCheck(target_turtle)
    elseif target_turtle_is_chunky == false then
        current_coordinates= sendCoordinateCheck(target_turtle)
    end
    io.write("Current Coordinates: ", current_coordinates.x .. ',' .. current_coordinates.y .. ',' .. current_coordinates.z,"\n")
    io.write("Press Enter To Close...")
    io.read()
end

function taskHandler(target_turtle,task_name,task_args1,task_args2,task_args3)
    if task_name == "multiPointPathingTask()" then
        multiPointPathingTask(target_turtle,task_args1)
    elseif task_name == "multiPointMiningTask()" then
        multiPointMiningTask(target_turtle,task_args1)
    elseif task_name == "multiLayerMiningTask()" then
        multiLayerMiningTask(target_turtle,task_args1,task_args2,task_args3)
    elseif task_name == "singlePointPathingTask()" then
        singlePointPathingTask(target_turtle,task_args1)
    elseif task_name == "findTask()" then
        findTask(target_turtle)
    end
end

function createMultiShellTask(target_turtle,task_name,task_args1,task_args2,task_args3)
    local id = multishell.launch({},"turtle_commander_v1.lua","slave",target_turtle,task_name,task_args1,task_args2,task_args3)
        multishell.setTitle(id, "ID#: " .. target_turtle)
end
 
function tester()
    -- current test turtle = 0
    -- current storage coords = -158,90,1000049
    -- current center coords = -158,-11,1000051
    -- current resume coords = -110,-11,1000051

    -- current test turtle = 29
    -- current storage coords = -254,13,1000050
    -- current center coords = -254,-28,1000051
    -- current resume coords = -206,-28,1000051

    print("resuming layer")
    center_of_mine = vector.new(-158,88,1000051)
    resume_at_coord = vector.new(-206,88,1000051)
    multipoint_path = calculateNWtoSESnakePath(center_of_mine, 1, 1)
    snake_path_array = resumeSnakeAtCoord(multipoint_path,resume_at_coord)
    print(snake_path_array[1])
    print(snake_path_array[2])
    print(snake_path_array[3])
    print(snake_path_array[4])
    print(snake_path_array[5])
    print(snake_path_array[6])
    print(snake_path_array[7])
    io.read()
end

local screenWidth, screenHeight = term.getSize()
local buttonWidth = 10
local buttonHeight = 3
local buttonSpacing = 5

local buttonColors = {
    colors.blue,
    colors.red,
    colors.green,
    colors.black
  }
  
local function displayASCIIArt()
    local monitorArt = {

        "  ===========================",
        "  =  Turtle Commander v1.0  =",
        "  ===========================",
        " ",
        "               __",
        "     .,-;-;-,. /'_\\",
        "  _/_/_/_|_\\_\\) /",
        "'-<_><_><_><_>=/\\",
        "   `/_/====/_/-'\\_\\",
        "    \"\"     \"\"    \"\"",
    }
    for i, line in ipairs(monitorArt) do
        term.setCursorPos(screenWidth / 2.1 - #line / 2 + 1, screenHeight / 3 - #monitorArt / 2 + i)
        term.write(line)
    end
end
  
local function onButton1Click()
    term.setBackgroundColor(colors.black)
    term.clear()
    term.setCursorPos(1, 1)
    io.write("ID#: ")
    target_turtle = tonumber(io.read())
    io.write("Target location coordinates (x,y,z): ")
    target_coordinates_string = io.read()
    target_coordinates = extract_coordinates(target_coordinates_string)
    createMultiShellTask(target_turtle,"singlePointPathingTask()",target_coordinates,0)
    term.clear()
    displayASCIIArt()
end

local function onButton2Click()
    term.setBackgroundColor(colors.black)
    term.clear()
    term.setCursorPos(1, 1)
    io.write("ID#: ")
    target_turtle = tonumber(io.read())
    io.write("Storage Drawer Coordinate (x,y,z): ")
    storage_coord_string = io.read()
    storage_coord = extract_coordinates(storage_coord_string)
    io.write("Center of mine (x,y,z): ")
    center_of_mine_string = io.read()
    center_of_mine = extract_coordinates(center_of_mine_string)
    io.write("Resume partial layer? (y/n): ")
    resume_layer = io.read()
    if resume_layer == "y" then
        io.write("Resume at (x,y,z): ")
        resume_at_coord_string = io.read()
        resume_at_coord = extract_coordinates(resume_at_coord_string)
    elseif resume_layer == "n" then
        resume_at_coord = 0
    end
    createMultiShellTask(target_turtle,"multiLayerMiningTask()",center_of_mine,resume_at_coord,storage_coord)
    term.clear()
    displayASCIIArt()
end

local function onButton3Click()
    term.setBackgroundColor(colors.black)
    term.clear()
    term.setCursorPos(1, 1)
    io.write("ID#: ")
    target_turtle = tonumber(io.read())
    createMultiShellTask(target_turtle,"findTask()",0,0)
    term.clear()
    displayASCIIArt()
end

local buttons = {
    {x = 6, y = screenHeight - buttonHeight - 2, text = "move", color = buttonColors[1], action = onButton1Click},
    {x = 6 + buttonWidth + buttonSpacing, y = screenHeight - buttonHeight - 2, text = "mine", color = buttonColors[2], action = onButton2Click},
    {x = 6 + 2 * (buttonWidth + buttonSpacing), y = screenHeight - buttonHeight - 2, text = "find", color = buttonColors[3], action = onButton3Click},
    {x = 600 + 2 * (buttonWidth + buttonSpacing), y = screenHeight - buttonHeight - 2, text = "none", color = buttonColors[4], action = nil}
    }

local function drawButton(button)
    for i = 0, buttonHeight - 1 do
        term.setCursorPos(button.x, button.y + i)
        term.setBackgroundColor(button.color)
        term.write(string.rep(" ", buttonWidth))
    end
    term.setTextColor(colors.white)
    term.setCursorPos(button.x + 3, button.y + math.floor(buttonHeight / 2))
    term.write(button.text)
end

local function isMouseClickInButton(x, y, button)
    return x >= button.x and x <= button.x + buttonWidth - 1 and y >= button.y and y <= button.y + buttonHeight - 1
end

function main()
    if (args[1] == "slave") then
        taskHandler(args[2],args[3],args[4],args[5],args[6])
    elseif (args[1] ~= "slave") then
        term.setBackgroundColor(colors.black)
        term.clear()
        displayASCIIArt()
        while true do
            for i, button in ipairs(buttons) do
                drawButton(button)
            end
            local event, button, x, y = os.pullEvent("mouse_click")
            if event == "mouse_click" and button == 1 then
                for i, buttonData in ipairs(buttons) do
                    if isMouseClickInButton(x, y, buttonData) then
                        buttonData.action()
                    end
                end
            end
            term.setBackgroundColor(colors.black)
        end
    end
end

main()